/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.settings;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.OverworldBiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DebugChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.NoiseChunkGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DimensionGeneratorSettings {
    public static final Codec<DimensionGeneratorSettings> field_236201_a_ = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(DimensionGeneratorSettings::func_236221_b_), (App)Codec.BOOL.fieldOf("generate_features").orElse((Object)true).stable().forGetter(DimensionGeneratorSettings::func_236222_c_), (App)Codec.BOOL.fieldOf("bonus_chest").orElse((Object)false).stable().forGetter(DimensionGeneratorSettings::func_236223_d_), (App)SimpleRegistry.func_241744_b_(Registry.field_239700_af_, Lifecycle.stable(), Dimension.field_236052_a_).xmap(Dimension::func_236062_a_, Function.identity()).fieldOf("dimensions").forGetter(DimensionGeneratorSettings::func_236224_e_), (App)Codec.STRING.optionalFieldOf("legacy_custom_options").stable().forGetter(dimensionGeneratorSettings -> dimensionGeneratorSettings.field_236209_i_)).apply((Applicative)instance, instance.stable(DimensionGeneratorSettings::new))).comapFlatMap(DimensionGeneratorSettings::func_236233_n_, Function.identity());
    private static final Logger field_236203_c_ = LogManager.getLogger();
    private final long field_236205_e_;
    private final boolean field_236206_f_;
    private final boolean field_236207_g_;
    private final SimpleRegistry<Dimension> field_236208_h_;
    private final Optional<String> field_236209_i_;

    private DataResult<DimensionGeneratorSettings> func_236233_n_() {
        Dimension dimension = this.field_236208_h_.func_230516_a_(Dimension.field_236053_b_);
        if (dimension == null) {
            return DataResult.error((String)"Overworld settings missing");
        }
        if (this.func_236234_o_()) {
            return DataResult.success((Object)this, (Lifecycle)Lifecycle.stable());
        }
        return DataResult.success((Object)this);
    }

    private boolean func_236234_o_() {
        return Dimension.func_236060_a_(this.field_236205_e_, this.field_236208_h_);
    }

    public DimensionGeneratorSettings(long l, boolean bl, boolean bl2, SimpleRegistry<Dimension> simpleRegistry) {
        this(l, bl, bl2, simpleRegistry, Optional.empty());
        Dimension dimension = simpleRegistry.func_230516_a_(Dimension.field_236053_b_);
        if (dimension == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
    }

    private DimensionGeneratorSettings(long l, boolean bl, boolean bl2, SimpleRegistry<Dimension> simpleRegistry, Optional<String> optional) {
        this.field_236205_e_ = l;
        this.field_236206_f_ = bl;
        this.field_236207_g_ = bl2;
        this.field_236208_h_ = simpleRegistry;
        this.field_236209_i_ = optional;
    }

    public static DimensionGeneratorSettings func_242752_a(DynamicRegistries dynamicRegistries) {
        MutableRegistry<Biome> mutableRegistry = dynamicRegistries.func_243612_b(Registry.field_239720_u_);
        int \u26032 = "North Carolina".hashCode();
        MutableRegistry<DimensionType> \u26033 = dynamicRegistries.func_243612_b(Registry.field_239698_ad_);
        MutableRegistry<DimensionSettings> \u26034 = dynamicRegistries.func_243612_b(Registry.field_243549_ar);
        return new DimensionGeneratorSettings(\u26032, true, true, DimensionGeneratorSettings.func_242749_a(\u26033, DimensionType.func_242718_a(\u26033, mutableRegistry, \u26034, \u26032), DimensionGeneratorSettings.func_242750_a(mutableRegistry, \u26034, \u26032)));
    }

    public static DimensionGeneratorSettings func_242751_a(Registry<DimensionType> registry, Registry<Biome> registry2, Registry<DimensionSettings> registry3) {
        long l = new Random().nextLong();
        return new DimensionGeneratorSettings(l, true, false, DimensionGeneratorSettings.func_242749_a(registry, DimensionType.func_242718_a(registry, registry2, registry3, l), DimensionGeneratorSettings.func_242750_a(registry2, registry3, l)));
    }

    public static NoiseChunkGenerator func_242750_a(Registry<Biome> registry, Registry<DimensionSettings> registry2, long l) {
        return new NoiseChunkGenerator(new OverworldBiomeProvider(l, false, false, registry), l, () -> registry2.func_243576_d(DimensionSettings.field_242734_c));
    }

    public long func_236221_b_() {
        return this.field_236205_e_;
    }

    public boolean func_236222_c_() {
        return this.field_236206_f_;
    }

    public boolean func_236223_d_() {
        return this.field_236207_g_;
    }

    public static SimpleRegistry<Dimension> func_242749_a(Registry<DimensionType> registry, SimpleRegistry<Dimension> simpleRegistry, ChunkGenerator chunkGenerator) {
        Dimension dimension = simpleRegistry.func_230516_a_(Dimension.field_236053_b_);
        Supplier<DimensionType> \u26032 = () -> dimension == null ? registry.func_243576_d(DimensionType.field_235999_c_) : dimension.func_236063_b_();
        return DimensionGeneratorSettings.func_241520_a_(simpleRegistry, \u26032, chunkGenerator);
    }

    public static SimpleRegistry<Dimension> func_241520_a_(SimpleRegistry<Dimension> simpleRegistry, Supplier<DimensionType> supplier, ChunkGenerator chunkGenerator) {
        SimpleRegistry<Dimension> simpleRegistry2 = new SimpleRegistry<Dimension>(Registry.field_239700_af_, Lifecycle.experimental());
        simpleRegistry2.func_218381_a(Dimension.field_236053_b_, new Dimension(supplier, chunkGenerator), Lifecycle.stable());
        for (Map.Entry<RegistryKey<Dimension>, Dimension> entry : simpleRegistry.func_239659_c_()) {
            RegistryKey<Dimension> registryKey = entry.getKey();
            if (registryKey == Dimension.field_236053_b_) continue;
            simpleRegistry2.func_218381_a(registryKey, entry.getValue(), simpleRegistry.func_241876_d(entry.getValue()));
        }
        return simpleRegistry2;
    }

    public SimpleRegistry<Dimension> func_236224_e_() {
        return this.field_236208_h_;
    }

    public ChunkGenerator func_236225_f_() {
        Dimension dimension = this.field_236208_h_.func_230516_a_(Dimension.field_236053_b_);
        if (dimension == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
        return dimension.func_236064_c_();
    }

    public ImmutableSet<RegistryKey<World>> func_236226_g_() {
        return (ImmutableSet)this.func_236224_e_().func_239659_c_().stream().map(entry -> RegistryKey.func_240903_a_(Registry.field_239699_ae_, ((RegistryKey)entry.getKey()).func_240901_a_())).collect(ImmutableSet.toImmutableSet());
    }

    public boolean func_236227_h_() {
        return this.func_236225_f_() instanceof DebugChunkGenerator;
    }

    public boolean func_236228_i_() {
        return this.func_236225_f_() instanceof FlatChunkGenerator;
    }

    public boolean func_236229_j_() {
        return this.field_236209_i_.isPresent();
    }

    public DimensionGeneratorSettings func_236230_k_() {
        return new DimensionGeneratorSettings(this.field_236205_e_, this.field_236206_f_, true, this.field_236208_h_, this.field_236209_i_);
    }

    public DimensionGeneratorSettings func_236231_l_() {
        return new DimensionGeneratorSettings(this.field_236205_e_, !this.field_236206_f_, this.field_236207_g_, this.field_236208_h_);
    }

    public DimensionGeneratorSettings func_236232_m_() {
        return new DimensionGeneratorSettings(this.field_236205_e_, this.field_236206_f_, !this.field_236207_g_, this.field_236208_h_);
    }

    public static DimensionGeneratorSettings func_242753_a(DynamicRegistries dynamicRegistries2, Properties properties) {
        DynamicRegistries dynamicRegistries2;
        String string2 = (String)MoreObjects.firstNonNull((Object)((String)properties.get("generator-settings")), (Object)"");
        properties.put("generator-settings", string2);
        \u2603 = (String)MoreObjects.firstNonNull((Object)((String)properties.get("level-seed")), (Object)"");
        properties.put("level-seed", \u2603);
        \u2603 = (String)properties.get("generate-structures");
        boolean \u26032 = \u2603 == null || Boolean.parseBoolean(\u2603);
        properties.put("generate-structures", Objects.toString(\u26032));
        \u2603 = (String)properties.get("level-type");
        \u2603 = Optional.ofNullable(\u2603).map(string -> string.toLowerCase(Locale.ROOT)).orElse("default");
        properties.put("level-type", \u2603);
        long \u26033 = new Random().nextLong();
        if (!\u2603.isEmpty()) {
            try {
                long l = Long.parseLong(\u2603);
                if (l != 0L) {
                    \u26033 = l;
                }
            }
            catch (NumberFormatException numberFormatException) {
                \u26033 = \u2603.hashCode();
            }
        }
        MutableRegistry<DimensionType> \u26034 = dynamicRegistries2.func_243612_b(Registry.field_239698_ad_);
        MutableRegistry<Biome> \u26035 = dynamicRegistries2.func_243612_b(Registry.field_239720_u_);
        MutableRegistry<DimensionSettings> \u26036 = dynamicRegistries2.func_243612_b(Registry.field_243549_ar);
        SimpleRegistry<Dimension> \u26037 = DimensionType.func_242718_a(\u26034, \u26035, \u26036, \u26033);
        switch (\u2603) {
            case "flat": {
                JsonObject jsonObject = !string2.isEmpty() ? JSONUtils.func_212745_a(string2) : new JsonObject();
                Dynamic \u26038 = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject);
                return new DimensionGeneratorSettings(\u26033, \u26032, false, DimensionGeneratorSettings.func_242749_a(\u26034, \u26037, new FlatChunkGenerator(FlatGenerationSettings.field_236932_a_.parse(\u26038).resultOrPartial(arg_0 -> ((Logger)field_236203_c_).error(arg_0)).orElseGet(() -> FlatGenerationSettings.func_242869_a(\u26035)))));
            }
            case "debug_all_block_states": {
                return new DimensionGeneratorSettings(\u26033, \u26032, false, DimensionGeneratorSettings.func_242749_a(\u26034, \u26037, new DebugChunkGenerator(\u26035)));
            }
            case "amplified": {
                return new DimensionGeneratorSettings(\u26033, \u26032, false, DimensionGeneratorSettings.func_242749_a(\u26034, \u26037, new NoiseChunkGenerator(new OverworldBiomeProvider(\u26033, false, false, \u26035), \u26033, () -> \u26036.func_243576_d(DimensionSettings.field_242735_d))));
            }
            case "largebiomes": {
                return new DimensionGeneratorSettings(\u26033, \u26032, false, DimensionGeneratorSettings.func_242749_a(\u26034, \u26037, new NoiseChunkGenerator(new OverworldBiomeProvider(\u26033, false, true, \u26035), \u26033, () -> \u26036.func_243576_d(DimensionSettings.field_242734_c))));
            }
        }
        return new DimensionGeneratorSettings(\u26033, \u26032, false, DimensionGeneratorSettings.func_242749_a(\u26034, \u26037, DimensionGeneratorSettings.func_242750_a(\u26035, \u26036, \u26033)));
    }

    public DimensionGeneratorSettings func_236220_a_(boolean bl, OptionalLong optionalLong) {
        SimpleRegistry<Dimension> simpleRegistry;
        long l = optionalLong.orElse(this.field_236205_e_);
        if (optionalLong.isPresent()) {
            simpleRegistry = new SimpleRegistry<Dimension>(Registry.field_239700_af_, Lifecycle.experimental());
            long \u26032 = optionalLong.getAsLong();
            for (Map.Entry<RegistryKey<Dimension>, Dimension> entry : this.field_236208_h_.func_239659_c_()) {
                RegistryKey<Dimension> registryKey = entry.getKey();
                simpleRegistry.func_218381_a(registryKey, new Dimension(entry.getValue().func_236059_a_(), entry.getValue().func_236064_c_().func_230349_a_(\u26032)), this.field_236208_h_.func_241876_d(entry.getValue()));
            }
        } else {
            simpleRegistry = this.field_236208_h_;
        }
        DimensionGeneratorSettings \u26033 = this.func_236227_h_() ? new DimensionGeneratorSettings(l, false, false, simpleRegistry) : new DimensionGeneratorSettings(l, this.func_236222_c_(), this.func_236223_d_() && !bl, simpleRegistry);
        return \u26033;
    }
}

